function [AR,Om] = do_LPIV_ARtest_MMO(LPIV,IRFnull,nvar,eta,C)

yy      = LPIV.vars(LPIV.p+1:end,nvar);                    % outcome variables
%if isempty(LPIV.varsy)
YY      = LPIV.vars(LPIV.p+1:end,1);                    % endogenous regressor
%else
%YY      = LPIV.varsy(LPIV.p+1:end,1);                    % endogenous regressor
%end  
XX      = lagmatrix(LPIV.vars,1:LPIV.p);
XX      = [XX(LPIV.p+1:end,:) LPIV.DET(LPIV.p+1:end,:)]; % controls
ZZ      = LPIV.taxshocks(LPIV.p+1:end,:);              % instruments

[LPIV.T,~] = size(yy);


AR = zeros(size(IRFnull))';

for h = 0:LPIV.irhor-1
    y = yy((1+h):end, :); %y_{t+h}, t=1,...,T-h
    Y = YY(1:(end-h), :); %Y_t      t=1,...,T-h
    X = XX(1:(end-h), :); %X_t      t=1,...,T-h
    % omit RHS regressor without variability other than constant: 
        varX = var(X);
        X(:,[varX(:,1:end-1) 1]<eps)=[];
    Z = ZZ(1:(end-h), :); %z_t      t=1,...,T-h
    M = eye((LPIV.T-h))-X*((X'*X)\X');
    zx_T  = (Z'*X)./(LPIV.T-h);
    xx_T  = (X'*X)./(LPIV.T-h);
    A     = [ -(zx_T)*((xx_T)\eye(size(xx_T,1))), 1 ];

    % Compute the residuals implied by the VAR model
    etaaux  = lagmatrix(eta,0:-1:-h);        
    etaaux  = reshape(etaaux(1:end-h,:),[LPIV.T-h,size(eta',1),h+1]);
    e0aux1  = zeros(LPIV.T-h,1,h+1);
    for i_h = 1:h+1
        c =squeeze(C(nvar,:,h+2-i_h));
    e0aux1(:,:,i_h) = etaaux(:,:,i_h)*c';
    end

    for nn= 1:length(IRFnull(1+h,:))
        AR(nn,1+h) = ((Z'*M*(y - (IRFnull(1+h,nn)*Y)))/((LPIV.T-h)^.5))^2;
        e0         = sum(e0aux1,3)- etaaux(:,1,1)*IRFnull(1+h,nn);   
        W     = NW_hac_STATA([bsxfun(@minus,bsxfun(@times,X,e0),mean(bsxfun(@times,X,e0),1)),Z.*e0-mean(Z.*e0,1)],LPIV.NWlags);
        Om(:,:,1+h,nn)   = A*W*A';
    end
% %3)Critical value
% 
% ARcval= (A*W*A')*chi2inv(1-alpha,1);
   
 
%     u           = Y-[X,Z]*(([X';Z']*[X,Z])\([X';Z']*Y)); 
%     v           = y-[X,Z]*(([X';Z']*[X,Z])\([X';Z']*y));
% 
%     XXp           = (X'*X)./(LPIV.T-h);
%     ZXp           = (Z'*X)./(LPIV.T-h);
%     A             = [ -(ZXp)*((XXp)\eye(size(XXp,1))), 1 , zeros(1,size(XXp,1)), 0 ; ...
%                        zeros(1,size(XXp,1))   , 0 , -(ZXp)*((XXp)\eye(size(XXp,1))),1];
%     ZMZp          = (Z'*M*Z/(LPIV.T-h));
%     W             = NW_hac_STATA([X.*v,Z.*v,X.*u, Z.*u],LPIV.NWlags);
%     Om(:,:,1+h)   = A*W*A'./(ZMZp^2);
end

